/* -----------------------------------------------------------------------------
 * An invalid character is automatically inserted by cvs when the file is 
 * commited. We can not do anything about it.
 * -----------------------------------------------------------------------------
 */ 


#ifndef __IAP_DEVCONF_H__
#define __IAP_DEVCONF_H__

#ifdef __cplusplus
extern "C" {
#endif

/* DEVCCONF entries for iPod */
#define IPOD_ACC_CAPS_BITSHIFT                  32
#define IPOD_DEVCONF_MAX_LEN                    64
#define IPOD_DEVCONF_FLG_LEN                    3
#define IPOD_DEVCONF_MAX_ARRAY                  256
    
#define IPOD_INST_COUNT                 "IPOD_INST_COUNT"

#define TSNAME_AUDIOWORKER              "TSNAME_AUDIOWORKER"
#define TSNAME_AUDIOREADER              "TSNAME_AUDIOREADER"
#define TSNAME_SEM_MODESWITCH           "TSNAME_SEM_MODESWITCH"
#define TSNAME_SEM_SENDER               "TSNAME_SEM_SENDER"
#define TSNAME_SEM_AUTHENTICATION       "TSNAME_SEM_AUTHENTICATION"
#define TSNAME_FLG_WORKER               "TSNAME_FLG_WORKER"
#define TSNAME_FLG_READER               "TSNAME_FLG_READER"
#define TSNAME_MBF_AUDIO                "TSNAME_MBF_AUDIO"

#define IPOD_USB_HID_DEVICE                 "IPOD_USB_HID_DEVICE"
#define IICDEVICE                           "IICDEVICE"
#define IPOD_USB_READ_RETRIES               "IPOD_USB_READ_RETRIES"
#define IPOD_USB_WAIT_TIMEOUT               "IPOD_USB_WAIT_TIMEOUT"
#define IPOD_USB_READER_TSK_PRIO            "IPOD_USB_READER_TSK_PRIO"
#define IPOD_USB_READER_TSK_STACKSIZE       "IPOD_USB_READER_TSK_STACKSIZE"
#define IPOD_USB_READER_TSK_LCID            "IPOD_USB_READER_TSK_LCID"
#define IPOD_WORKER_TSK_PRIO                "IPOD_WORKER_TSK_PRIO"
#define IPOD_WORKER_TSK_STACKSIZE           "IPOD_WORKER_TSK_STACKSIZE"
#define IPOD_WORKER_TSK_LCID                "IPOD_WORKER_TSK_LCID"

#define IPOD_TOKEN_IDENTIFY_GENERAL        "IPOD_TOKEN_IDENTIFY_GENERAL"
#define IPOD_TOKEN_IDENTIFY_SIMPLE         "IPOD_TOKEN_IDENTIFY_SIMPLE"
#define IPOD_TOKEN_IDENTIFY_DISPLAY_REMOTE "IPOD_TOKEN_IDENTIFY_DISPLAY_REMOTE"
#define IPOD_TOKEN_IDENTIFY_EXTEND         "IPOD_TOKEN_IDENTIFY_EXTEND"
#define IPOD_TOKEN_IDENTIFY_AUDIO          "IPOD_TOKEN_IDENTIFY_AUDIO"
#define IPOD_TOKEN_IDENTIFY_STORAGE        "IPOD_TOKEN_IDENTIFY_STORAGE"
#define IPOD_TOKEN_IDENTIFY_IPODOUT        "IPOD_TOKEN_IDENTIFY_IPODOUT"
#define IPOD_TOKEN_IDENTIFY_LOCATION       "IPOD_TOKEN_IDENTIFY_LOCATION"
#define IPOD_TOKEN_ACCCAPS                 "IPOD_TOKEN_ACCCAPS"
#define IPOD_TOKEN_PREFERENCE              "IPOD_TOKEN_PREFERENCE"
#define IPOD_TOKEN_PREF_SET_FLG            "IPOD_TOKEN_PREF_SET_FLG"

#define IPOD_TOKEN_ACCINFO_NAME                 "IPOD_TOKEN_ACCINFO_NAME"
#define IPOD_TOKEN_ACCINFO_FW_VER               "IPOD_TOKEN_ACCINFO_FW_VER"
#define IPOD_TOKEN_ACCINFO_HW_VER               "IPOD_TOKEN_ACCINFO_HW_VER"
#define IPOD_TOKEN_ACCINFO_MANUFACTURE          "IPOD_TOKEN_ACCINFO_MANUFACTURE"
#define IPOD_TOKEN_ACCINFO_MODEL_NUM            "IPOD_TOKEN_ACCINFO_MODEL_NUM"
#define IPOD_TOKEN_ACCINFO_SERIAL_NUM           "IPOD_TOKEN_ACCINFO_SERIAL_NUM"
#define IPOD_TOKEN_ACCINFO_STATUS_TYPES         "IPOD_TOKEN_ACCINFO_STATUS_TYPES"
#define IPOD_TOKEN_ACCINFO_FLG                  "IPOD_TOKEN_ACCINFO_FLG"
#define IPOD_TOKEN_PROTOCOL_STR                 "IPOD_TOKEN_PROTOCOL_STR"
#define IPOD_TOKEN_BUNDLE_STR                   "IPOD_TOKEN_BUNDLE_STR"
#define IPOD_TOKEN_METADATA                     "IPOD_TOKEN_METADATA"
#define IPOD_TOKEN_ACC_STATUS                   "IPOD_TOKEN_ACC_STATUS"
#define IPOD_TOKEN_RF_CERTIFICATIONS            "IPOD_TOKEN_RF_CERTIFICATIONS"

#define IPOD_LOCATION_ASSIST_SUPPORT            "IPOD_LOCATION_ASSIST_SUPPORT"
#define IPOD_LOCATION_ASSIST_CAPS               "IPOD_LOCATION_ASSIST_CAPS"
#define IPOD_LOCATION_SATEL_POS_MAX_REFRESH     "IPOD_LOCATION_SATEL_POS_MAX_REFRESH"
#define IPOD_LOCATION_SATEL_POS_RECOM_REFRESH   "IPOD_LOCATION_SATEL_POS_RECOM_REFRESH"

#define IPOD_OUT_TOTAL_WIDTH_INCHES             "IPOD_OUT_TOTAL_WIDTH_INCHES"
#define IPOD_OUT_TOTAL_HEIGHT_INCHES            "IPOD_OUT_TOTAL_HEIGHT_INCHES"
#define IPOD_OUT_TOTAL_WIDTH_PIXELS             "IPOD_OUT_TOTAL_WIDTH_PIXELS"
#define IPOD_OUT_TOTAL_HEIGHT_PIXELS            "IPOD_OUT_TOTAL_HEIGHT_PIXELS"
#define IPOD_OUT_WIDTH_PIXELS                   "IPOD_OUT_WIDTH_PIXELS"
#define IPOD_OUT_HEIGHT_PIXELS                  "IPOD_OUT_HEIGHT_PIXELS"
#define IPOD_OUT_FEATURES_MASK                  "IPOD_OUT_FEATURES_MASK"
#define IPOD_OUT_GAMMA_VALUE                    "IPOD_OUT_GAMMA_VALUE"

#define IPOD_MAX_PAYLOAD_SIZE                   "IPOD_MAX_PAYLOAD_SIZE"

#ifdef __cplusplus
}
#endif

#endif/*__IAP_DEVCONF_H__*/ 

